/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifier.tinkers_ingenuity;

import com.xiaoyue.tinkers_ingenuity.generic.XIRModifier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class SoulDevouring
extends XIRModifier {
    private final ResourceLocation KEY = new ResourceLocation("tinkers_ingenuity", "soul");

    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.KEY);
    }

    @Override
    public int onModifierAfterHit(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float damageDealt) {
        if (target.m_21224_() && damageDealt > 0.0f) {
            ModDataNBT toolData = tool.getPersistentData();
            if (toolData.contains(this.KEY, 5)) {
                toolData.putFloat(this.KEY, toolData.getFloat(this.KEY) + 0.2f * (float)level);
            } else {
                toolData.putFloat(this.KEY, 0.2f * (float)level);
            }
        }
        return level;
    }

    @Override
    public float onModifierGetDamage(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float baseDamage, float damage) {
        ModDataNBT toolData = tool.getPersistentData();
        return baseDamage + toolData.getFloat(this.KEY);
    }

    @Override
    public void onArrowHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, int level, AbstractArrow arrow, EntityHitResult hit, LivingEntity attacker, LivingEntity target) {
        arrow.m_36781_(arrow.m_36789_() + (double)persistentData.getFloat(this.KEY));
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player != null) {
            ModDataNBT toolData = tool.getPersistentData();
            if (toolData.contains(this.KEY, 5)) {
                tooltip.add((Component)this.applyStyle(new TranslatableComponent("modifier.tinkers_ingenuity.soul_devouring.attack_damage").m_130946_("" + toolData.getFloat(this.KEY))));
            } else {
                this.addDamageTooltip(tool, 0.0f, tooltip);
            }
        }
    }
}

